
rm(list = ls())

library("readr")
library("dplyr")
library("readxl")
library("writexl")
library("stringr")
library("ggplot2")
options(scipen=999)

EMPAQUETADOS <- read.csv("~/EMPAQUETAMIENTO_MOVIL_8.csv", sep=";", dec=",")

M <- filter(EMPAQUETADOS, MODALIDAD_PAGO != "Prepago sin compra")
M <- filter(M, ANNO > 2022)

M$MES <- (M$TRIMESTRE - 1) * 3 + M$MES_DEL_TRIMESTRE
M$MES <- str_pad(M$MES, width = 2, pad = "0")

M$FECHA <- paste(M$ANNO, M$MES, sep = "-")

BD <- M %>% group_by(FECHA, EMPRESA, SERVICIO_PAQUETE) %>% summarise(ACCESOS = sum(CANTIDAD_LINEAS), .groups = 'drop') %>% as.data.frame()
BD <- merge(BD, BD %>% group_by(FECHA, SERVICIO_PAQUETE) %>% summarise(TOTAL_ACCESOS = sum(ACCESOS), .groups = 'drop') %>% as.data.frame())
BD$SH <- BD$ACCESOS / BD$TOTAL_ACCESOS

BD <- filter(BD, SERVICIO_PAQUETE == "Voz móvil + internet móvil")

IHH <- as.data.frame(unique(BD[c("FECHA")]))
IHH$IHH <- 0

for (i in 1:nrow(IHH)) {
    b <- filter(BD, FECHA %in% IHH[i, 1])
    c <- as.numeric(b$SH %*% b$SH)
    IHH[i, 2] <- c
}

BD_1 <- BD
BD_1$EMPRESA <- ifelse(BD_1$EMPRESA == "COLOMBIA TELECOMUNICACIONES S.A. E.S.P.", "COLOMBIA MOVIL  S.A ESP", BD_1$EMPRESA)
BD_1 <- BD_1 %>% group_by(FECHA, SERVICIO_PAQUETE, EMPRESA) %>% summarise(ACCESOS = sum(ACCESOS), .groups = 'drop') %>% as.data.frame()
BD_1 <- merge(BD_1, BD_1 %>% group_by(FECHA, SERVICIO_PAQUETE) %>% summarise(TOTAL_ACCESOS = sum(ACCESOS), .groups = 'drop') %>% as.data.frame())
BD_1$SH <- BD_1$ACCESOS / BD_1$TOTAL_ACCESOS
BD_1 <- filter(BD_1, FECHA == "2024-12")

RESUMEN <- as.data.frame(unique(BD_1[c("FECHA")]))
RESUMEN$SERVICIO_PAQUETE <- BD[1,2]
RESUMEN$IHH_PREVIO <- IHH[24,2]
RESUMEN$IHH_POSTERIOR <- as.numeric(BD_1$SH%*%BD_1$SH)
RESUMEN$D_IHH <- RESUMEN$IHH_POSTERIOR - RESUMEN$IHH_PREVIO

write_xlsx(BD, "a. SM.xlsx")
write_xlsx(IHH, "b. IHH SM.xlsx")
write_xlsx(RESUMEN, "c. IHH Integración SM.xlsx")
